function out = get_oxygen_mask(fix_time, glaciation_threshold, smoothing_time, dFlag)

if nargin < 4
    dFlag = 0;
end

% derives exposure history from benthic oxygen stack of Lisiecki & Raymo
% (2005).

% Lisiecki, L. E., & Raymo, M. E. (2005). A Pliocene?Pleistocene stack of 
% 57 globally distributed benthic ?18O records. Paleoceanography, 20(1)
% https://doi.org/10.1029/2004pa001071

% this has all gotten a bit too cumbersome because in old version used 1
% for glaciation and 0 for interglaciaiton. Now want a production mask, so
% use 0 for glaciation (no production) and 1 for interglaciation
% (production). 

%% Load and parse dataset

data = load('LR04.txt'); % load LRO4 stack

data = data(data(:, 1) <= 2700, :); % cap at 2.7 Myr

% if there is a cutoff time, truncate datset

% data = data(data(:, 1) >= fix_time, :);

oxygen_raw = data(:, 2); % vectorize d18O data

time = data(:, 1).*1e3; % vectorize time data

time_interp = 0:1e3:2.7e6; 
oxygen_interp = interp1(time, oxygen_raw, time_interp);

%% filter

% smooth data using resolution specified in input
b = (1/smoothing_time)*ones(1, smoothing_time);
a = 1; 

oxygen_isotopes = filter(b, a, oxygen_interp);

% oxygen_isotopes(1:2*smoothing_time) = oxygen_interp(1:2*smoothing_time);

%% get all in correct shape and direction
oxygen_isotopes = oxygen_isotopes';
time_interp = time_interp';

% start with earliest time
oxygen_isotopes = flipud(oxygen_isotopes);
time = flipud(time_interp);

% truncate at fix_time
oxygen_isotopes = oxygen_isotopes(time >= fix_time);
time = time(time >= fix_time);
%% create mask usign glaciation threshold

glaciation_mask = oxygen_isotopes >= glaciation_threshold; % 1 = ice-covered, 0 = ice-free

% find index where each ice cover period starts and ends

%% find model times and ice-cover mask

switch_diff = diff(glaciation_mask); % if difference is -1, then going from ice cover to no ice cover; if difference is 1, going from no ice cover to cover. 
switch_indx = find(or(switch_diff == 1, switch_diff == -1));
switch_indx_full = [1; switch_indx; length(time)];

switch_val = switch_diff(switch_indx);

switch_times = time(switch_indx_full);

model_times = abs(diff(switch_times));

model_mask = zeros(length(model_times), 1);

if model_mask(1) == 1
    model_mask(1) = 0;
elseif model_mask(1) == 0
    model_mask(1) = 1;
end

for a = 1:length(model_mask(2:end))
    if switch_val(a) == 1
        model_mask(a+1) = 0;
    elseif switch_val(a) == -1
        model_mask(a+1) = 1;
    end
end

% package results to pass back upstream

out.t_eb = model_times';
out.p_mask = model_mask';

% other variables that used to be output: time, oxygen_isotopes, switch_times

if dFlag == 1
    out.switch_times = switch_times;
    out.model_times = model_times;
    out.model_mask = model_mask;
    out.oxygen_isotopes = oxygen_isotopes;
    out.time = time;
    out.glaciation_threshold = glaciation_threshold;
end
% to check if times translated correctly. 
% figure
% hold on
% plot(time(glaciation_mask == 1), 3.*ones(length(time(glaciation_mask == 1)), 1), 'bo')
% plot(time(glaciation_mask == 0), 3.*ones(length(time(glaciation_mask == 0)), 1), 'ro')
% 
% for a = 1:length(model_times)
%     if model_mask(a) == 1
%         plot([switch_times(a) (switch_times(a)-model_times(a))], [5 5], 'r', 'LineWidth', 4)
%     elseif model_mask(a) == 0
%         plot([switch_times(a) (switch_times(a)-model_times(a))], [5 5], 'b', 'LineWidth', 4)
%     end
% end
%  plot(time, oxygen_isotopes)
%  plot(time, glaciation_threshold.*ones(length(time), 1), 'k-')
%  set(gca, 'ydir', 'reverse')
% 
% ylim([0 8])

end